(defun c:campin()
(setq F (getvar "blipmode")) (setvar "blipmode" 0)
(setq p (getpoint "\n Insert point:"))
(setq D (getreal "\n Enter body diameter [12] [15] [20] [25] [30] [35] [40]:"))
(setq T1 (getreal "\n Enter cavity plate thickness:"))
(setq T2 (getreal "\n Enter sliding plate thickness:"))
(setq L (getreal "\n Enter sliding plate desired stroke:"))
(setq A (getreal "\n Enter agpin angle [12] [15] [18] [20] [22] [25]:"))
(setq B (- (* pi (/ A 180.0)) (/ pi 2)))
(setq C (* pi (/ A 180)))
(setq N1 (/ T1 (abs (cos C))))
(setq N2 (/ L (abs (sin C))))
(setq N3 (* (/ D 2) (abs (/ (sin C) (cos C)))))
(if (= D 12)
 (progn
  (setq D2 17)
  (setq H 10)))
(if (= D 15)
 (progn
  (setq D2 20)
  (setq H 12)))
(if (= D 20)
 (progn
  (setq D2 25)
  (setq H 15)))
(if (= D 25)
 (progn
  (setq D2 30)
  (setq H 15)))
(if (= D 30)
 (progn
  (setq D2 35)
  (setq H 20)))
(if (= D 35)
 (progn
  (setq D2 40)
  (setq H 20)))
(if (= D 40)
 (progn
  (setq D2 45)
  (setq H 25)))
(setq D1 (- D 1))
(setq D3 (+ D2 1))
(setq N4 (/ (/ D2 2) (abs (cos C))))
(setq N5 (/ (/ D3 2) (abs (cos C))))
(setq p2 (polar p B N1))
(setq p1 (polar p2 B (* -1 N3)))
(setq p3 (polar p2 B N2))
(setq p4 (polar p B H))
(setq p5 (polar p1 (+ B (/ pi 2)) (/ D1 2)))
(setq p6 (polar p1 (- B (/ pi 2)) (/ D1 2)))
(setq p7 (polar p1 (+ B (/ pi 2)) (/ D 2)))
(setq p8 (polar p1 (- B (/ pi 2)) (/ D 2)))
(setq p9 (polar p4 (+ B (/ pi 2)) (/ D 2)))
(setq p10 (polar p4 (- B (/ pi 2)) (/ D 2)))
(setq p11 (polar p4 (+ B (/ pi 2)) (/ D2 2)))
(setq p12 (polar p4 (- B (/ pi 2)) (/ D2 2)))
(setq p13 (polar p4 (+ B (/ pi 2)) (/ D3 2)))
(setq p14 (polar p4 (- B (/ pi 2)) (/ D3 2)))
(setq p19 (polar p (- B (/ pi 2)) (/ D2 2)))
(setq p15 (polar p (- (+ B (/ pi 2)) C) N4))
(setq p16 (polar p (- (- B (/ pi 2)) C) N4))
(setq p17 (polar p (- (+ B (/ pi 2)) C) N5))
(setq p18 (polar p (- (- B (/ pi 2)) C) N5))
(setq p20 (polar p3 (+ B (/ pi 2)) (/ D1 2)))
(setq p21 (polar p3 (- B (/ pi 2)) (/ D1 2)))
(setq p22 (polar p B (/ (+ T1 T2) (abs (cos C)))))
(setq p23 (polar p22 pi (/ (/ D 2) (abs (cos C)))))
(setq p24 (polar p22 0 (/ (/ D 2) (abs (cos C)))))
(setq p30 (polar p (- B (/ pi 2)) (/ D2 -2)))
(setq X (+ (distance p p3) (* 0.5 D)))
(prompt "\n Cam pin length:") (princ X)
(setq Q (getstring "\n Do you want to continue <Y>?"))
(if (or (eq Q "Y") (eq Q "y") (eq Q ""))
(progn
(command "line" p17 p13 p14 p18 "")
(if (> C 0)
 (progn
  (command "line" p15 p11 "")
  (command "line" p p19 p12 ""))
 (progn
  (command "line" p16 p12 "")
  (command "line" p p30 p11 "")))
(command "line" p9 p24 "")
(command "line" p10 p23 "")
(command "line" p7 p8 "")
(command "line" p5 p20 "")
(command "line" p6 p21 "")
(command "arc" p21 "C" p3 p20)
(setq N6 (* (+ N1 N2 (/ D1 2)) (abs (cos C))))
(if (>= N6 (+ T1 T2))
 (progn
  (IF (> C 0)
  (progn
  (setq p25 (polar p3 (/ pi -2) (+ 3 (/ D1 2))))
  (setq p26 (polar p3 0 (+ 1 (/ D1 2))))
  (setq p27 (list (car p23) (cadr p25)))
  (setq p28 (list (car p26) (cadr p25)))
  (setq p29 (list (car p26) (cadr p23)))
  (command "line" p23 p27 p28 p29 ""))
  (progn
  (setq p25 (polar p3 (/ pi -2) (+ 3 (/ D1 2))))
  (setq p26 (polar p3 pi (+ 1 (/ D1 2))))
  (setq p27 (list (car p24) (cadr p25)))
  (setq p28 (list (car p26) (cadr p25)))
  (setq p29 (list (car p26) (cadr p23)))
  (command "line" p24 p27 p28 p29 ""))
)))))
(setvar "blipmode" F))
